// JavaScript Document
$("#comprobacion-error").hide();
$("#comprobacion-ok").hide();

function showNotification(colorName, text, placementFrom, placementAlign, animateEnter, animateExit) 
{
	if (colorName === null || colorName === '') { colorName = 'bg-black'; }
	if (text === null || text === '') { text = 'Turning standard Bootstrap alerts'; }
	if (animateEnter === null || animateEnter === '') { animateEnter = 'animated fadeInDown'; }
	if (animateExit === null || animateExit === '') { animateExit = 'animated fadeOutUp'; }
	var allowDismiss = true;

	$.notify({
		message: text
	},
		{
			type: colorName,
			allow_dismiss: allowDismiss,
			newest_on_top: true,
			timer: 500,
			placement: {
				from: placementFrom,
				align: placementAlign
			},
			animate: {
				enter: animateEnter,
				exit: animateExit
			},
			template: '<div data-notify="container" class="bootstrap-notify-container alert alert-dismissible {0} ' + (allowDismiss ? "p-r-35" : "") + '" role="alert">' +
			'<button type="button" aria-hidden="true" class="close" data-notify="dismiss">×</button>' +
			'<span data-notify="icon"></span> ' +
			'<span data-notify="title">{1}</span> ' +
			'<span data-notify="message">{2}</span>' +
			'<div class="progress" data-notify="progressbar">' +
			'<div class="progress-bar progress-bar-{0}" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>' +
			'</div>' +
			'<a href="{3}" target="{4}" data-notify="url"></a>' +
			'</div>'
		});
}

function actualiza_fecha()
{
	var fecha = $("#field-fecha").val ();
	var id_porcionado = $("#id_porcionado").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/actualiza_fecha",
	{
		id_porcionado: id_porcionado,
		fecha: fecha,
	},
	function(data, status){
		showNotification('alert-success', 'Fecha actualizada.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_area()
{
	var id_area = $("#field_id_area").val ();
	var id_porcionado = $("#id_porcionado").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/actualizar_area",
	{
		id_area: id_area,
		id_porcionado: id_porcionado,
	},
	function(data, status){
		showNotification('alert-success', 'Área actualizada.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_area_destino()
{
	var id_area_destino = $("#field_id_area_destino").val ();
	var id_porcionado = $("#id_porcionado").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/actualizar_area_destino",
	{
		id_area_destino: id_area_destino,
		id_porcionado: id_porcionado,
	},
	function(data, status){
		showNotification('alert-success', 'Área de destino actualizada.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_producto_porcionado()
{
	var id_producto_porcionado = $("#field_id_producto_conformar").val ();
	var id_porcionado = $("#id_porcionado").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/actualizar_producto_porcionado",
	{
		id_porcionado: id_porcionado,
		id_producto_porcionado: id_producto_porcionado,
	},
	function(data, status){
		showNotification('alert-success', 'Producto a porcionar actualizado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_cantidad_porcionar()
{
	var cantidad_porcionar = $("#field-cantidad_porcionar").val ();
	var id_porcionado = $("#id_porcionado").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/actualizar_cantidad_porcionar",
	{
		id_porcionado: id_porcionado,
		cantidad_porcionar: cantidad_porcionar,
	},
	function(data, status){
		showNotification('alert-success', 'Cantidad de producto a porcionar actualizada.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_costo_porcionado()
{
	var costo_porcionado = $("#field-costo_porcionado").val ();
	var id_porcionado = $("#id_porcionado").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/actualizar_costo_porcionado",
	{
		id_porcionado: id_porcionado,
		costo_porcionado: costo_porcionado,
	},
	function(data, status){
		showNotification('alert-success', 'Costo de porcionado actualizado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_porcionador()
{
	var id_porcionador = $("#field_id_porcionador").val ();
	var id_porcionado = $("#id_porcionado").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/actualizar_porcionador",
	{
		id_porcionador: id_porcionador,
		id_porcionado: id_porcionado,
	},
	function(data, status){
		showNotification('alert-success', 'Porcionador actualizado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

//boton de agregar producto
$(document).ready(function () {
	$("#btn-modal").click(function(){
		$("#alerta-error").hide();
		$(".chosen-select").chosen("destroy");
		$('#ag_id_producto').val (-1);
		$('#ag_cantidad').val (0);
		$('#ag_indice').val (0);
		$(".chosen-select").chosen();
		$(".chosen-container").css("width", "100%");
	});
});

function chequea_disponibilidad ()
{
	var id_producto = $("#field_id_producto_conformar").val ();
	var id_area = $("#field_id_area").val ();
	var cantidad = $("#field-cantidad_porcionar").val ();
	var id_porcionado = $("#id_porcionado").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/chequea_disponibilidad",
	{
		id_producto: id_producto,
		id_area: id_area,
		cantidad: cantidad,
		id_porcionado: id_porcionado,
	},
	function(data, status){
		if ( data == 1 ) {
			$("#todo-correcto").show ();
			$("#todo-mal").hide ();
			$("#save-and-go-back-button").show ();
		}
		else {
			$("#todo-correcto").hide ();
			$("#todo-mal").show ();
			$("#save-and-go-back-button").hide ();
		}
	});
}

$(document).ready(function () {
	$("#btn-agregar-mat").click(function(){
		var id_producto_sel = $("#ag_id_producto").val ();
		var id_nm = "#mat-"+id_producto_sel;
		var producto_nombre = $(id_nm).html ();
		var producto_cantidad = parseFloat ( $("#ag_cantidad").val () );
		var producto_indice = $("#ag_indice").val ();
		var id_porcionado = $("#id_porcionado").val ();
		if ( id_producto_sel != '' && producto_cantidad != "" && producto_cantidad > 0 && producto_indice != "" )
		{
			//mando toda la info para agregar producto
			var url = $("#site_url").val ();
			$.post(url+"almacen/porcionado/agrega_producto",
			{
				id_producto: id_producto_sel,
				producto_cantidad: producto_cantidad,
				producto_indice: producto_indice,
				id_porcionado: id_porcionado,
			},
			function(data, status){
				$("#Modal-agregar").modal("hide");
				$(".chosen-select").chosen("destroy");
				$(".chosen-select").chosen();
				$(".chosen-container").css("width", "100%");
				
				genera_tabla_productos ();
				showNotification('alert-success', 'Producto agregado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
			});
		}
		else
		{
			$("#texto-error-mat").html ( 'Debe introducir todos los parámetros.' );
			if ( existencia_producto < producto_cantidad )
				$("#texto-error-mat").html ( 'No hay existencias suficientes.' );
			$("#alerta-error").show();
		}
		
	});
});	

function genera_tabla_productos ()
{
	var id_porcionado = $("#id_porcionado").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/genera_tabla_productos",
	{
		id_porcionado: id_porcionado,
	},
	function(data, status){
		$("#tabla-producto").html (data);
	});
}

function elimina_este_producto ( id_ef )
{
	var boton = "#btn-eliminar-producto-" + id_ef;
	$(boton).parents("tr").remove();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/elimina_este_producto",
	{
		id_ef: id_ef,
	},
	function(data, status){
		showNotification('alert-success', 'Producto eliminado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualiza_cantidad_producto ( id_ef, id_producto )
{
	var campo = "#producto_cantidad-" + id_ef;
	var cantidad = $(campo).val();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/actualiza_cantidad_producto",
	{
		id_ef: id_ef,
		id_producto: id_producto,
		cantidad: cantidad,
	},
	function(data, status){
		genera_tabla_productos ();
	});
}

//fijo el fijar_porcionado 
$(document).ready(function () {
	$("#save-and-go-back-button").click(function(){
		if ( $("#field-fecha").val () > '0000-00-00' && $("#field_id_area").val () > 0 && $("#field_total_producto").val () > 0 && $("#field_id_producto_conformar").val () > 0 && $("#field-cantidad_porcionar").val () > 0  && $("#field_id_porcionador").val () > 0 && $("#field-costo_porcionado").val () >= 0 ) {
			$("#save-and-go-back-button").hide();
			var id_porcionado = $("#id_porcionado").val ();
			var url = $("#site_url").val ();
			$.post(url+"almacen/porcionado/fijar_porcionado",
			{
				id_porcionado: id_porcionado,
			},
			function(data, status){
				if (data != '' ) {
					$("#Modal-finalizar").modal("hide");
					$("#save-and-go-back-button").show();
					showNotification('alert-danger', data, 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
				}
				else {
					window.location.assign ( url+"almacen/porcionado/index" );
				}
			});	
		}
		else {
			$("#Modal-finalizar").modal("hide");
			$("#save-and-go-back-button").show();
			showNotification('alert-danger', 'Faltan registros básicos del porcionado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
		}
		
	});
});

function actualiza_observaciones ()
{
	var id_porcionado = $("#id_porcionado").val ();
	var observaciones = $("#field-observaciones").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/porcionado/actualiza_observaciones",
	{
		id_porcionado: id_porcionado,
		observaciones: observaciones,
	},
	function(data, status){
		showNotification('alert-success', 'Observaciones actualizadas.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}