// JavaScript Document
$("#comprobacion-error").hide();
$("#comprobacion-ok").hide();

function showNotification(colorName, text, placementFrom, placementAlign, animateEnter, animateExit) 
{
	if (colorName === null || colorName === '') { colorName = 'bg-black'; }
	if (text === null || text === '') { text = 'Turning standard Bootstrap alerts'; }
	if (animateEnter === null || animateEnter === '') { animateEnter = 'animated fadeInDown'; }
	if (animateExit === null || animateExit === '') { animateExit = 'animated fadeOutUp'; }
	var allowDismiss = true;

	$.notify({
		message: text
	},
		{
			type: colorName,
			allow_dismiss: allowDismiss,
			newest_on_top: true,
			timer: 500,
			placement: {
				from: placementFrom,
				align: placementAlign
			},
			animate: {
				enter: animateEnter,
				exit: animateExit
			},
			template: '<div data-notify="container" class="bootstrap-notify-container alert alert-dismissible {0} ' + (allowDismiss ? "p-r-35" : "") + '" role="alert">' +
			'<button type="button" aria-hidden="true" class="close" data-notify="dismiss">×</button>' +
			'<span data-notify="icon"></span> ' +
			'<span data-notify="title">{1}</span> ' +
			'<span data-notify="message">{2}</span>' +
			'<div class="progress" data-notify="progressbar">' +
			'<div class="progress-bar progress-bar-{0}" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>' +
			'</div>' +
			'<a href="{3}" target="{4}" data-notify="url"></a>' +
			'</div>'
		});
}

function actualiza_fecha()
{
	var fecha = $("#field-fecha").val ();
	var id_elaboracion = $("#id_elaboracion").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/actualiza_fecha",
	{
		id_elaboracion: id_elaboracion,
		fecha: fecha,
	},
	function(data, status){
		showNotification('alert-success', 'Fecha actualizada.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_area()
{
	var id_area = $("#field_id_area").val ();
	var id_elaboracion = $("#id_elaboracion").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/actualizar_area",
	{
		id_area: id_area,
		id_elaboracion: id_elaboracion,
	},
	function(data, status){
		showNotification('alert-success', 'Área de materias primas actualizada.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_area_destino()
{
	var id_area_destino = $("#field_id_area_destino").val ();
	var id_elaboracion = $("#id_elaboracion").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/actualizar_area_destino",
	{
		id_area_destino: id_area_destino,
		id_elaboracion: id_elaboracion,
	},
	function(data, status){
		showNotification('alert-success', 'Área de destino actualizada.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_elaborador()
{
	var id_elaborador = $("#field_id_elaborador").val ();
	var id_elaboracion = $("#id_elaboracion").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/actualizar_elaborador",
	{
		id_elaborador: id_elaborador,
		id_elaboracion: id_elaboracion,
	},
	function(data, status){
		showNotification('alert-success', 'Elaborador actualizado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_producto_elaborado()
{
	var id_producto_elaborado = $("#field_id_producto_conformar").val ();
	var id_elaboracion = $("#id_elaboracion").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/actualizar_producto_elaborado",
	{
		id_elaboracion: id_elaboracion,
		id_producto_elaborado: id_producto_elaborado,
	},
	function(data, status){
		showNotification('alert-success', 'Producto elaborado actualizado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_cantidad_elaborada()
{
	var cantidad_elaborada = $("#field-cantidad_elaborada").val ();
	var id_elaboracion = $("#id_elaboracion").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/actualizar_cantidad_elaborada",
	{
		id_elaboracion: id_elaboracion,
		cantidad_elaborada: cantidad_elaborada,
	},
	function(data, status){
		showNotification('alert-success', 'Cantidad de producto elaborado actualizado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_costo_embalaje()
{
	var costo_embalaje = $("#field-costo_embalaje").val ();
	var id_elaboracion = $("#id_elaboracion").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/actualizar_costo_embalaje",
	{
		id_elaboracion: id_elaboracion,
		costo_embalaje: costo_embalaje,
	},
	function(data, status){
		showNotification('alert-success', 'Costo de embalaje actualizado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualizar_costo_elaboracion()
{
	var costo_elaboracion = $("#field-costo_elaboracion").val ();
	var id_elaboracion = $("#id_elaboracion").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/actualizar_costo_elaboracion",
	{
		id_elaboracion: id_elaboracion,
		costo_elaboracion: costo_elaboracion,
	},
	function(data, status){
		showNotification('alert-success', 'Costo de elaboración actualizado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

//boton de agregar producto
$(document).ready(function () {
	$("#btn-modal").click(function(){
		$("#alerta-error").hide();
		$(".chosen-select").chosen("destroy");
		$('#ag_id_producto').val (-1);
		$('#ag_cantidad').val (0);
		$(".chosen-select").chosen();
		$(".chosen-container").css("width", "100%");
	});
});

function chequea_disponibilidad ()
{
	var id_producto_sel = $("#ag_id_producto").val ();
	var id_area = $("#ag_id_area").val ();
	var cantidad = $("#ag_cantidad").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/chequea_disponibilidad",
	{
		id_producto: id_producto_sel,
		id_area: id_area,
		cantidad: cantidad,
	},
	function(data, status){
		var info = JSON.parse(data);
		$("#ag_costo_producto").val(info.costo);
		$("#ag_existencia_producto").val(info.existencia);
	});
}

function agrega_producto_elaborar ()
{
		var id_producto_sel = $("#ag_id_producto").val ();
		var id_nm = "#mat-"+id_producto_sel;
		var producto_nombre = $(id_nm).html ();
		var producto_cantidad = parseFloat ( $("#ag_cantidad").val () );
		var costo_producto = $("#ag_costo_producto").val();
		var existencia_producto = parseFloat ( $("#ag_existencia_producto").val() );
		var id_elaboracion = $("#id_elaboracion").val ();
		var id_area = $("#ag_id_area").val ();
		if ( id_producto_sel != '' && producto_cantidad != "" && producto_cantidad > 0 && existencia_producto >= producto_cantidad )
		{
			//mando toda la info para agregar producto
			var url = $("#site_url").val ();
			$.post(url+"almacen/elaboracion/agrega_producto",
			{
				id_producto: id_producto_sel,
				producto_cantidad: producto_cantidad,
				id_elaboracion: id_elaboracion,
				id_area: id_area,
			},
			function(data, status){
				$("#Modal-agregar").modal("hide");
				$(".chosen-select").chosen("destroy");
				$(".chosen-select").chosen();
				$(".chosen-container").css("width", "100%");
				
				genera_tabla_productos ();
				showNotification('alert-success', 'Producto agregado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
			});
		}
		else
		{
			$("#texto-error-mat").html ( 'Debe introducir todos los parámetros.' );
			if ( existencia_producto < producto_cantidad )
				$("#texto-error-mat").html ( 'No hay existencias suficientes.' );
			$("#alerta-error").show();
		}
}

$(document).ready(function () {
	$("#btn-agregar-mat").click(function(){
		var id_producto_sel = $("#ag_id_producto").val ();
		var id_area = $("#ag_id_area").val ();
		var cantidad = $("#ag_cantidad").val ();
		var url = $("#site_url").val ();
		$.post(url+"almacen/elaboracion/chequea_disponibilidad",
		{
			id_producto: id_producto_sel,
			id_area: id_area,
			cantidad: cantidad,
		},
		function(data, status){
			var info = JSON.parse(data);
			$("#ag_costo_producto").val(info.costo);
			$("#ag_existencia_producto").val(info.existencia);
			agrega_producto_elaborar ();
		});
	});
});	

function genera_tabla_productos ()
{
	var id_elaboracion = $("#id_elaboracion").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/genera_tabla_productos",
	{
		id_elaboracion: id_elaboracion,
	},
	function(data, status){
		$("#tabla-producto").html (data);
	});
}

function elimina_este_producto ( id_ef )
{
	var boton = "#btn-eliminar-producto-" + id_ef;
	$(boton).parents("tr").remove();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/elimina_este_producto",
	{
		id_ef: id_ef,
	},
	function(data, status){
		showNotification('alert-success', 'Producto eliminado.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}

function actualiza_cantidad_producto ( id_ef, id_producto )
{
	var campo = "#producto_cantidad-" + id_ef;
	var cantidad = $(campo).val();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/actualiza_cantidad_producto",
	{
		id_ef: id_ef,
		id_producto: id_producto,
		cantidad: cantidad,
	},
	function(data, status){
		genera_tabla_productos ();
	});
}

//fijo el la elaboración 
$(document).ready(function () {
	$("#save-and-go-back-button").click(function(){
		if ( $("#field-fecha").val () > '0000-00-00' && $("#field-costo_embalaje").val () >= 0 && $("#field-costo_elaboracion").val () >= 0 && $("#field_total_producto").val () > 0 && $("#field_id_producto_conformar").val () > 0 && $("#field-cantidad_elaborada").val () > 0 && $("#field_id_area_destino").val () > 0 && $("#field_id_elaborador").val () > 0 ) {
			$("#save-and-go-back-button").hide();
			var id_elaboracion = $("#id_elaboracion").val ();
			var url = $("#site_url").val ();
			$.post(url+"almacen/elaboracion/fijar_elaboracion",
			{
				id_elaboracion: id_elaboracion,
			},
			function(data, status){
				if (data != '' ) {
					$("#Modal-finalizar").modal("hide");
					$("#save-and-go-back-button").show();
					showNotification('alert-danger', data, 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
				}
				else {
					window.location.assign ( url+"almacen/elaboracion/index" );
				}
			});	
		}
		else {
			$("#Modal-finalizar").modal("hide");
			$("#save-and-go-back-button").show();
			showNotification('alert-danger', 'Faltan registros básicos de la elaboración.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
		}
		
	});
});

function actualiza_observaciones ()
{
	var id_elaboracion = $("#id_elaboracion").val ();
	var observaciones = $("#field-observaciones").val ();
	var url = $("#site_url").val ();
	$.post(url+"almacen/elaboracion/actualiza_observaciones",
	{
		id_elaboracion: id_elaboracion,
		observaciones: observaciones,
	},
	function(data, status){
		showNotification('alert-success', 'Observaciones actualizadas.', 'top', 'right', 'animated bounceInDown', 'animated bounceOutUp');
	});
}